-- Überstunden- und Mindestpausenberechnung
-- https://redmine.prodat-sql.de/projects/prodat-v-x/wiki/Stempeln
CREATE OR REPLACE FUNCTION bdep__a_iu() RETURNS TRIGGER AS $$
  DECLARE
      bdsaldo             numeric(12,4);  -- Summe Einzelstempelungen Saldo (netto, bereits OHNE Pausen) > Wiki
      dienstgang_saldo    numeric(12,4);
      bd_arbstu_minpause  numeric(12,4);
      f3                  numeric(12,4);
      gpause              numeric(12,4);  -- Gesamt genommene Pause am Tag: Summe aus direkten Abzug in Einzelstempelung (bdep) zzgl. der Abwesendzeiten
      last_bd_end         timestamp(0) without time zone;
      r                   record;
      ueberrund           numeric(12,4);
      uebschwelle         numeric(12,4);
      uebermin            numeric(12,4);
      tplanminpause       numeric(12,4);  -- Mindestpause gem. Tagesplan
      _gesamt_pausenminuten_ignore_mindestpause numeric(12,4);
      minPausenAbzug      numeric(12,4);  -- Zusätzlicher Pausenabzug, da Mindestpausen nicht eingehalten wurden.
      tplmin              numeric(12,4);
      ueberfrac           numeric(12,4);
      _tplan_record       record;
      tplanname           varchar;
      bdab_stu_gutschrift numeric;
      -- Settings
      bdepab_minpause__max_saldo_ueber_sollzeit boolean;  -- 'BDE.bdepab_minpause__max_saldo_ueber_sollzeit' (versteckt)
      BDEP_tpl_uebstund_Unterzeit_Runden        boolean;  -- 'BDEP.tpl_uebstund.Unterzeit.Runden'

      _id_pause          integer = 110;

      _debugmessages      boolean = current_user IN ('root', 'docker', 'postgres');
  BEGIN
    IF TSystem.current_user_in_syncro_dblink() OR new.bd_buch THEN RETURN new; END IF; -- Änderungen verwerfen. Das ist bereits verbucht.

    IF tg_op = 'UPDATE' THEN
        -- Hier ändert sich etwas an der Pause, die Folgestempelungen müssen neu berechnet werden.
        IF old.bd_restpause <> new.bd_restpause THEN
            UPDATE bdep SET
              bd_gleitpause = NULL,
              bd_blockpause = NULL
            WHERE bd_id = (
                SELECT bd_id
                FROM bdep
                WHERE bd_minr = new.bd_minr
                  AND bd_individwt_mpl_date = new.bd_individwt_mpl_date
                  AND bd_anf > new.bd_anf
                ORDER BY bd_anf LIMIT 1
                )
            ;
        END IF;
    END IF;

    -- Initial: alte Mindestpausen weg, Stammdaten aus Tagesplan, Überstunden, Überstundenschwelle, Rundung usw.
        -- Alte Mindestpause löschen.
        DELETE FROM bdepab
         WHERE bdab_aus_id = 101 -- Abwesenheitsgrund Mindestpause!!
           AND bdab_minr = new.bd_minr
           AND new.bd_individwt_mpl_date BETWEEN bdab_anf AND bdab_end
         ;

        -- Tagesplan-Daten
        SELECT tplan.* INTO _tplan_record FROM mitpln JOIN tplan ON tpl_name = mpl_tpl_name WHERE mpl_date = new.bd_individwt_mpl_date AND mpl_minr = new.bd_minr;
        tplanname := _tplan_record.tpl_name;

        SELECT tpl_minpause,  tpl_uebstund, tpl_uebstundab / 60,  tpl_min
          INTO tplanminpause, ueberrund,    uebschwelle,          tplmin
          FROM tplan
         WHERE tpl_name = tplanname;


        -- Settings
          -- Mindestpause: Maximal der Präsenzzeit-Anteil über Arbeitszeit-Grenze für globale Mindestpause, siehe #11814.
          -- Die Mindestpause wird anteilig und erst mit Überschreiten der Arbeitszeit-Grenze (globale Mindestpause) abgezogen. Der Anteil ist dabei maximal die Zeit über der Arbeitszeit-Grenze.
          -- Bsp: ab 6 h Präsenzzeit 0:30 h Soll-Pause, 6:10 Präsenzzeit = 0:10 h Abzug durch autom. Mindestpause.
          -- zus. Bedingung: Eintrag in TP-Mindestpause muss NULL sein.
          bdepab_minpause__max_saldo_ueber_sollzeit := TSystem.Settings__GetBool('BDE.bdepab_minpause__max_saldo_ueber_sollzeit', true); -- #11814, hidden setting, default true

          -- Setting 1: Überzeit UND Unterzeit anhand Überzeitrundung des Tagesplans runden.
          -- Setting 0: Überzeitrundung nur bei Überzeit. Wenn Unterzeit, dann normal anhand Tagesplan-Rundung.
          BDEP_tpl_uebstund_Unterzeit_Runden := TSystem.Settings__GetBool('BDEP.tpl_uebstund.Unterzeit.Runden');
        --

        -- Variablen initialisieren
        gpause := 0; minPausenAbzug := 0; last_bd_end := NULL;
    --

    -- Pausen: Pausen in Stempelzeiten SOWIE alle Zwischenzeiten (Zeiten in denen der Arbeitnehmer ausgestempelt hatte) als Pause zusammenziehen.
    SELECT sum(bd_saldo),  sum( coalesce(bd_gleitpause, 0) + coalesce(bd_blockpause, 0) )
      INTO bdsaldo,        gpause
      FROM bdep
     WHERE bd_minr = new.bd_minr
       AND bd_individwt_mpl_date = new.bd_individwt_mpl_date
       AND bd_end IS NOT NULL;

    -- eingetragene Abwesenheiten "Pause" anrechnen.
    gpause :=
        gpause
        + coalesce(
            ( SELECT sum(abs(bdab_stu))
                FROM bdepab
               WHERE bdab_minr = new.bd_minr
                 AND bdab_anf = new.bd_individwt_mpl_date
                 AND bdab_stu < 0
                 AND tpersonal.bdeabgruende__type__pause(bdab_aus_id) -- = 110
            )
            , 0
          )
    ;

    -- Pausen errechnen: Pausen durch ausgestempelte Zeiten
    -- Achtung derzeit OHNE Flag. Man könnte hier nur die Zeiten zählen, welche auch als Pause abgestempelt wurden (z.B. ausschließen Dienstwege?!).
    FOR r IN
        SELECT bd_anf_rund, bd_end_rund, bd_aus_id, bd_id
          FROM bdep
         WHERE bd_minr = new.bd_minr
           AND bd_individwt_mpl_date = new.bd_individwt_mpl_date
         ORDER BY bd_anf_rund, bd_id
    LOOP
        IF last_bd_end IS NOT NULL -- wir hatten schon eine Stempelung
          THEN
            gpause := gpause + timediff(last_bd_end, r.bd_anf_rund); -- Das ist eine Pause, die der Mitarbeiter gestempelt hatte.

            -- Summe Dienstgang während der Abwesenheit. Das zählt nicht als Pause zwischen den Stempelungen!
            -- Bsp Mitarbeiter geht 12 Uhr, 12:15 wird Dienstreise eingetragen bis 14 Uhr. Mitarbeiter stempelt 14:15 wieder an
            SELECT sum(bdab_stu) 
              INTO dienstgang_saldo 
              FROM bdepab 
             WHERE bdab_minr = new.bd_minr 
               AND tpersonal.bdeabgruende__type__dienstgang(bdab_aus_id)
               AND bdab_anf = new.bd_individwt_mpl_date
               AND bdab_anft IS NOT null
               AND bdab_endt IS NOT null
               AND bdab_anft >= last_bd_end::time(0)
               AND bdab_endt <= r.bd_anf_rund::time(0)
               ;

            gpause := gpause - coalesce(dienstgang_saldo, 0);

            IF _debugmessages THEN -- Debug
                RAISE NOTICE '3: last_bd_end = %; bd_anf = %; diff = %; gpause = %', last_bd_end, r.bd_anf_rund, timediff(last_bd_end, r.bd_anf_rund), gpause;
            END IF;
        END IF;

        last_bd_end := r.bd_end_rund; -- zwischenzeitliche Abstempelungen zählen als Pause.


        IF    (TSystem.Settings__GetBool('bdep__pausen__bd_aus_id__id_pause__only', false) IS false -- Alle Abstände zur vorherigen Stempelung zählen als Pause
            OR r.bd_aus_id IN ( _id_pause )) -- Oder es wurde mit Pause abgestempelt
        THEN
            -- Alle Abstände zur vorherigen Stempelung zählen als Pause
            IF current_user IN ('root', 'docker') THEN -- Debug
                RAISE NOTICE '3: SET last_bd_end = %, r.bd_aus_id = %', r.bd_end_rund, r.bd_aus_id;
            END IF;            
            last_bd_end := r.bd_end_rund; -- zwischenzeitliche Abstempelungen zählen als Pause.
        ELSE
            -- der Abstand zur letzten Stempelung zählt nur dann als Pause, wenn diese mit Pause abgestempelt wurde
            IF current_user IN ('root', 'docker') THEN -- Debug
                RAISE NOTICE '3: SKIP last_bd_end = %, r.bd_aus_id = %', r.bd_end_rund, r.bd_aus_id;
            END IF;            
            last_bd_end := null;
        END IF;        
    END LOOP;

    -- Gesamtsumme Dienstgang für den Tag
    SELECT sum(bdab_stu)
      INTO dienstgang_saldo
      FROM bdepab
     WHERE bdab_minr = new.bd_minr
       AND tpersonal.bdeabgruende__type__dienstgang(bdab_aus_id)
       AND bdab_anf = new.bd_individwt_mpl_date
       AND bdab_stu IS NOT null -- 3 Fälle: Uhrzeiten vollständige => ergibt bdab_stu. Keine Uhrzeiten und bdab_stu manuell eingegeben. Kompletter Tag ohne Uhrzeiten und ohne Gutschrift (dann gutschrift gem. Tagesplan)
       ;

    bd_arbstu_minpause := coalesce(bdsaldo, 0) + coalesce(dienstgang_saldo, 0);

    -- gpause hält jetzt die Summe aller Pausen: gestempelte Pausen durch Abwesenheiten sowie vom System an der Stempelung abgezogene Pausen.

    -- Pausenzeiträume, die NICHT zur Mindestpause zählen!
      -- Alle Stempelung des Mitarbeiters/Tag gegen alle Pausenzeiten für den Tagesplan/Tag
      WITH 
        pausen AS (
          SELECT --bd.bd_minr,
                 tsrange(bd.bd_anf, bd.bd_end, '[)') AS arbeitszeit,
                 tsrange(
                   bd.bd_individwt_mpl_date + tplp.tplp_begin,
                   bd.bd_individwt_mpl_date + tplp.tplp_end,
                   '[)'
                 ) AS pausezeit
            FROM bdep bd
            JOIN mitpln ON mpl_date = bd_individwt_mpl_date AND mpl_minr = bd_minr  
           CROSS JOIN tplanpause tplp 
           WHERE bd.bd_end IS NOT NULL
             AND tplp_minpause_ignore
             AND bd_individwt_mpl_date = new.bd_individwt_mpl_date AND bd_minr = new.bd_minr --= '2025-07-01' AND bd_minr = 39
             AND tplp_tpl_name = mpl_tpl_name
        ),
        -- Alle Stempelungen die sich überlappen und wieviel
        ueberlappung AS (
          SELECT --bd_minr,
                 upper(arbeitszeit * pausezeit) - lower(arbeitszeit * pausezeit) AS overlap_duration
            FROM pausen
           WHERE arbeitszeit && pausezeit
        )
        -- Summe der Überlappungen
        SELECT--bd_minr,
               ROUND(SUM(EXTRACT(EPOCH FROM overlap_duration)) / 60.0)/*Minuten*/ / 60 /*Industrie-Minuten*/ 
          INTO -- AS 
               _gesamt_pausenminuten_ignore_mindestpause
          FROM ueberlappung;
       --GROUP BY bd_minr; 

      IF coalesce(_gesamt_pausenminuten_ignore_mindestpause, 0) > 0 THEN
        IF _debugmessages THEN -- Debug
            RAISE NOTICE '_gesamt_pausenminuten_ignore_mindestpause = % gpause = % _gesamt_pausenminuten_ignore_mindestpause', gpause, _gesamt_pausenminuten_ignore_mindestpause;
        END IF;      
        gpause := gpause - _gesamt_pausenminuten_ignore_mindestpause;
      END IF;
    --

    -- Mindestpausen eingehalten? > https://redmine.prodat-sql.de/issues/17018
        -- Prüfen, ob die Summe der genommenen Pausen in Kombination mit der Arbeitszeit für Mindestpausen ausreichend ist.

        -- 1. Prüfung auf Mindestpause gemäß Tagesplan
        IF _debugmessages THEN -- Debug
            RAISE NOTICE 'tplanminpause = % gpause = % minPausenAbzug = % tplanminpause > gpause = %', tplanminpause, gpause, minPausenAbzug, tplanminpause > gpause;
        END IF;

        IF tplanminpause IS NOT NULL AND tplanminpause > gpause THEN -- Wenn mehr Pause hätte genommen werden müssen (gemäß Tagesplan).
            -- Ermittlung der Pause, die noch genommen hätte werden müssen.
            -- Keine Rundung anhand Überzeitrundung (ueberrund), sondern bloß auf 4 NK genau.
            minPausenAbzug := tplanminpause - gpause;

            IF _debugmessages THEN -- Debug
                RAISE NOTICE '"tplanminpause > gpause" minPausenAbzug: % tplanminpause: % gpause: %', minPausenAbzug, tplanminpause, gpause;
            END IF;
        END IF;

        -- Mindestpause einhalten, wenn Arbeitszeit größer als X.
        -- Durchläuft die Mindestpause von unten nach oben und zieht immer jeweils ab.
        FOR r IN
            SELECT mp_arbstu, mp_minpause
              FROM minpause
             WHERE mp_arbstu < bd_arbstu_minpause
             ORDER BY mp_arbstu
        LOOP
            -- Trotz Arbeitszeit-Minus, der noch zu nehmenden Pause (laut Tagesplan), ist Grenzwert der Arbeitszeit für globale Mindestpause überschritten.
            IF r.mp_arbstu < bd_arbstu_minpause - minPausenAbzug THEN

                IF _debugmessages THEN -- Debug
                    RAISE NOTICE 'Minpausenberech: r.mp_arbstu = %, bd_arbstu_minpause = %; bdsaldo = % (-minPausenAbzug); dienstgang_saldo = %; r.mp_minpause = % gpause = % minPausenAbzug = % r.mp_minpause > gpause + minPausenAbzug = %, r.mp_minpause - gpause - minPausenAbzug = %'
                                ,                  r.mp_arbstu,     bd_arbstu_minpause,     bdsaldo,                       dienstgang_saldo,     r.mp_minpause,    gpause,    minPausenAbzug,    r.mp_minpause > gpause + minPausenAbzug,     r.mp_minpause - gpause - minPausenAbzug;
                END IF;

                -- Mindestpause bei der angegebenen Arbeitszeit nicht eingehalten.
                IF r.mp_minpause > gpause + minPausenAbzug THEN

                    -- Ermittlung der Pause, die noch genommen hätte werden müssen.
                    IF bdepab_minpause__max_saldo_ueber_sollzeit THEN -- siehe oben und #11814

                        -- Eintrag Tagesplan-Mindestpause wird bevorzugt (0 = keine Pause laut TP).
                        IF tplanminpause IS NULL THEN
                            -- Maximal abziehen: Arbeitszeit über Grenzwert der Arbeitszeit für globale Mindestpause (9 h Grenze, 45 min globale Mindestpause, 15 min gestempelte Pause bzw. feste Pausen, 9:10 h Arbeitszeit = 10 min).
                            -- GREATEST: Grenzwert der Arbeitszeit muss erst erreicht werden, bevor globale Mindestpause abgezogen wird.
                            -- Obergrenze ist globale Mindestpause abzgl. bereits gestempelter Pause (9:31 h Arbeitszeit (und mehr) = 45 - 15 = 30 min).
                            minPausenAbzug := LEAST(GREATEST(bd_arbstu_minpause - r.mp_arbstu, 0), r.mp_minpause - gpause);
                        END IF;
                    ELSE
                        minPausenAbzug := r.mp_minpause - gpause; -- Pause komplett abziehen (altes Verhalten vor #11814)
                    END IF;

                    IF _debugmessages THEN -- Debug
                        RAISE NOTICE '"r.mp_minpause > gpause + minPausenAbzug" minPausenAbzug: % r.mp_minpause: % gpause: %', minPausenAbzug, r.mp_minpause, gpause;
                    END IF;
                END IF;
            END IF;
        END LOOP;
    -- Mindestpause

    -- Eintragen der zusätzlichen Mindestpause in bdepab.
    IF minPausenAbzug > 0 THEN
        -- Wenn kein Tagesplan hinterlegt ist, dann keine globale Mindestpause einfügen. #6785
        IF tplanname IS NOT NULL THEN
            -- Mindestpause eintragen in Form von Abzug.
            INSERT INTO bdepab  (bdab_anf,                  bdab_end,                  bdab_minr,   bdab_aus_id,  bdab_stu)
            VALUES              (new.bd_individwt_mpl_date, new.bd_individwt_mpl_date, new.bd_minr, 101,        - minPausenAbzug);
        ELSE
            minPausenAbzug := 0; -- In Zusammenhang mit #6785 betrachten. Wenn kein Eintrag der Mindespause, darf keine Mindestpause in mpl_saldo addiert werden, s.u..
        END IF;
    END IF;

    -- Überzeitrundung. Hier muss klar sein, wieviel Mindestpause nach (Brutto) Arbeitszeit abgezogen wird,
    -- da ja die Überstunde entsprechend erst gar nicht zählen, wenn sie vorher durch Mindestpause wieder (teilweise) aufgehoben werden.

    -- kein Tagesplan, dann minutengenaue Arbeitszeit
    IF tplanname IS NULL THEN
        bdsaldo := round(bdsaldo * 60) / 60;
    ELSE
        -- mindestens minutengenau
        ueberrund := GREATEST(ueberrund, 1);

        -- Arbeitszeit (bdsaldo) ohne restliche Mindestpause (Tagesplan-Mindestpause ohne gestempelte Pausen). Negative Restpause erzeugt keine Arbeitszeit, mindestens 0.
        -- Diese echte, minutengenaue Arbeitszeit wird anhand Überzeitrundung abgerundet.
        -- Mindestpause wird nicht anhand Überzeitrundung gerundet, sondern minutengenau erfasst.
        bdsaldo := bdsaldo - GREATEST(minPausenAbzug, 0);

        -- Neue Berechnung des ganze Blocks (Beachte allerdings Änderung: Unterzeit keine Rundung anhand Überzeitrundung)
          -- arbeitszeit := f4;
          -- arbeitszeit := arbeitszeit - (((((arbeitszeit - tplmin) * 60) % ueberrund) + ueberrund) % ueberrund) / 60;

        ueberfrac := bdsaldo - tplmin - trunc(bdsaldo - tplmin);

        IF _debugmessages THEN -- Debug
            RAISE NOTICE 'bdsaldo: %; ueberfrac: %', bdsaldo, ueberfrac;
        END IF;

        -- Jetzt eigentliche Überstundenberechnung
        IF     BDEP_tpl_uebstund_Unterzeit_Runden -- Setting, s.o.
            OR (  -- eigentliche Überstundenberechnung
                  (ueberfrac >= 0)
              AND (bdsaldo - tplmin >= 0)
            )
        THEN
            IF ( ( ( (ueberfrac * 60)::INTEGER ) % ueberrund ) <> 0 ) THEN -- AND NOT (Round(ueberfrac * 60) % ueberrund = 0)
                uebermin := ueberfrac * 60; -- Nun haben wir die Überminuten!
                f3 := uebermin;

                IF _debugmessages THEN -- Debug
                    RAISE NOTICE 'uebermin: %', uebermin;
                END IF;

                uebermin := uebermin::INTEGER / ueberrund::INTEGER * ueberrund; -- Damit haben wir abgerundet die bewilligte Überzeit / mit Integer ergibt DIV.
                IF _debugmessages THEN -- Debug
                    RAISE NOTICE 'uebermin1: %', uebermin;
                END IF;

                -- Stundenanteile dazurechnen
                f3 := trunc(bdsaldo - tplmin); -- Überstunden stunden

                -- Setting 1: Überzeit UND Unterzeit anhand Überzeitrundung des Tagesplans runden.
                -- UND wir haben Unterzeit, dann aufrunden und nicht abrunden der Zeiten.
                IF BDEP_tpl_uebstund_Unterzeit_Runden AND ((uebermin < 0) OR (bdsaldo - tplmin < 0)) THEN
                    uebermin := uebermin - ueberrund;
                END IF;

                -- nun zurückschreiben
                bdsaldo := tplmin + uebermin / 60 + f3; -- Das ist die gerundete Überzeit (ergeben aus Sollzeit Tagesplan und gerundeten Überstunden).
            END IF;
        END IF;
    END IF;

    -- Wir schreiben die neuen Stunden in den Tagesplan auf.
    IF _debugmessages THEN -- Debug
        RAISE NOTICE 'bdsaldo_rund: % uebschwelle: % tplmin: % minPausenAbzug: %', bdsaldo, uebschwelle, tplmin, minPausenAbzug;
        RAISE NOTICE 'bdsaldo - tplmin: %', bdsaldo - tplmin;
    END IF;

    -- Mindestüberstunden eingehalten
    IF      (coalesce(uebschwelle, 0) > 0)
        AND (bdsaldo - tplmin > 0)
        AND (bdsaldo - tplmin < uebschwelle)
    THEN
        bdsaldo := tplmin;
       -- Wir haben zwar Überzeit, aber zu wenig = nicht anerkannt. => wir setzen das Saldo einfach per Hand auf die Vorgabe.
       -- Pausenabzu dazu addieren: Vorgabe ist 8 Stunden, ich arbeite 8,75; Ueberstundenschwelle = 0,5. Mindestpause = 0,5.
       -- Die Mindestpause wird vom System eingetragen, wenn der MAB nicht stempelt.
    END IF;

    -- Übertragung Ergebnis in mitpln
    UPDATE mitpln SET
      mpl_saldo = bdsaldo + coalesce(minPausenAbzug, 0)
    WHERE mpl_minr = new.bd_minr
      AND mpl_date = new.bd_individwt_mpl_date
    ;

    RETURN new;
  END $$ LANGUAGE plpgsql;